#include "stm32f10x.h"
#include "delay.h"
#include "usart.h"
#include "adc.h"
#include "DMA.h"



 void Display_Adc_Val(u16 Adc_Val)       //ʾ12λADCֵ
{
	u8 qian,bai,shi,ge;
	qian=Adc_Val/1000;
	bai =Adc_Val/100%10;
	shi =Adc_Val/10%10;
	ge = Adc_Val%10;
	UART1_SendByte(qian+'0');
	UART1_SendByte(bai +'0');
	UART1_SendByte(shi +'0');
	UART1_SendByte(ge +'0');
}




void Display_Adc_Vol(u16 Adc_Vol)       //ʾADѹֵ
{
	u16 decimal1,decimal2,decimal3;       //λС
	float temp;
	u16 temp1;
	
	temp=(float)Adc_Vol*(3.3/4096);    //ADѹֵ
	temp1=temp;                       //ȡõѹֵ
	
	UART1_SendByte(temp1+'0');        //ʾ
	
	temp-=temp1;                   //ȡõѹֵС
	temp*=1000;                   //ѹֵŴ1000С
	
	decimal1=(u16)temp/100;       //Сһλ
	decimal2=(u16)temp%100/10;    //Сڶλ
	decimal3=(u16)temp%10;        //Сλ
  
	UART1_SendByte('.');           //ʾС
	UART1_SendByte(decimal1+'0');  //ʾСһλ
	UART1_SendByte(decimal2+'0');  //ʾСڶλ
	UART1_SendByte(decimal3+'0');  //ʾСλ
	
}



void Display_ADC(void)           //ʾ12λADCֵ͵ѹֵ
{
	
	
	UART1_SendString("CH0:");                    //ͨ0ʾ"CH0:"
	Display_Adc_Val(ReadADCAverageValue(0));    //ʾͨADC1ͨ012λADCֵ 
	UART1_SendByte('\t');                       //ƱַADCֵ͵ѹֵʾֿ
	Display_Adc_Vol(ReadADCAverageValue(0));    //ʾͨADC1ͨ0ĵѹֵλС 
	UART1_SendByte('V');                        //ʾ"V"
	UART1_SendString("\r\n");                  //س      
	
  UART1_SendString("CH1:");                  //ͨ1
	Display_Adc_Val(ReadADCAverageValue(1));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(1));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH2:");                   //ͨ2
	Display_Adc_Val(ReadADCAverageValue(2));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(2));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH3:");                   //ͨ3
	Display_Adc_Val(ReadADCAverageValue(3));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(3));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH4:");                   //ͨ4
	Display_Adc_Val(ReadADCAverageValue(4));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(4));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH5:");                   //ͨ5
	Display_Adc_Val(ReadADCAverageValue(5));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(5));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH6:");                  //ͨ6
	Display_Adc_Val(ReadADCAverageValue(6));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(6));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH7:");                  //ͨ7
	Display_Adc_Val(ReadADCAverageValue(7));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(7));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH8:");                  //ͨ8
	Display_Adc_Val(ReadADCAverageValue(8));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(8));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
	
  UART1_SendString("CH9:");                  //ͨ9
	Display_Adc_Val(ReadADCAverageValue(9));
	UART1_SendByte('\t');
	Display_Adc_Vol(ReadADCAverageValue(9));
	UART1_SendByte('V');
	UART1_SendString("\r\n");
			
	
}

 

 
 int main(void)
 {	


	SystemInit();	      //ϵͳʼ
	delay_init();	    	//ʱʼ	  
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);//жȼΪ22λռȼ2λӦȼ
	uart_init(115200);    //ڳʼ115200
	Adc_Init();           //ADCDMAʼ
	 
   
  while(1)
	{
		
		 while(USART_GetFlagStatus(USART1,USART_FLAG_TXE)==RESET);//ȴɷһλ׶
		 Display_ADC();                                           //ʾ12λADCֵ͵ѹֵ                                    
		 UART1_SendString("\r\n");                                //س
		 delay_ms(500);                                           //ʱ500ms
		
	}
	
 }
 

