 #include "adc.h"
 #include "delay.h"
 #include "DMA.h"


/*****ͨӦϵCH0--PA0CH1--PA1CH2--PA2CH3--PA3CH4--PA4CH5--PA5CH6--PA6CH7--PA7CH8--PA8CH9--PA9****/


__IO u16 ADC_ConvertedValue[Sample_Num][Channel_Num];       //ά飬ADCתҲDMAĿַ


void  Adc_Init(void)
{ 	
	ADC_InitTypeDef ADC_InitStructure; 
	GPIO_InitTypeDef GPIO_InitStructure;

	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA|RCC_APB2Periph_GPIOB|RCC_APB2Periph_ADC1, ENABLE );	  //ʹGPIOA,GPIOBADC1ͨʱ
 

	RCC_ADCCLKConfig(RCC_PCLK2_Div6);   //ADCƵ6 72M/6=12,ADCʱ䲻ܳ14M

	                       
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0|GPIO_Pin_1|GPIO_Pin_2|GPIO_Pin_3|GPIO_Pin_4|GPIO_Pin_5|GPIO_Pin_6|GPIO_Pin_7;   //PA0-PA7 Ϊģͨ  
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;		//ģ
	GPIO_Init(GPIOA, &GPIO_InitStructure);	        //ʼGPIOA
	                        
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_0|GPIO_Pin_1;         //PB0-PB1 Ϊģͨ  
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AIN;		            //ģ
	GPIO_Init(GPIOB, &GPIO_InitStructure);                      //ʼGPIOB
	
	
	MYDMA_Config();    //DMA1ʼ
	

	ADC_DeInit(ADC1);  //λADC1 
	

	ADC_InitStructure.ADC_Mode = ADC_Mode_Independent;	//ADCģʽ:ADC1ADC2ڶģʽ
	ADC_InitStructure.ADC_ScanConvMode = ENABLE;	//ģתɨģʽ
	ADC_InitStructure.ADC_ContinuousConvMode = ENABLE;	//ģתתģʽ
	ADC_InitStructure.ADC_ExternalTrigConv = ADC_ExternalTrigConv_None;	//תⲿ
	ADC_InitStructure.ADC_DataAlign = ADC_DataAlign_Right;	//ADCҶ
	ADC_InitStructure.ADC_NbrOfChannel =Channel_Num;	//˳йתADCͨĿ
	ADC_Init(ADC1, &ADC_InitStructure);	//ADC_InitStructָĲʼADCxļĴ   
	
	
	ADC_RegularChannelConfig(ADC1, ADC_Channel_0, 1, ADC_SampleTime_239Cycles5 );         //ADC1,ADC ͨ x,˳ֵΪ y,ʱΪ 239.5 ڣͬ
	ADC_RegularChannelConfig(ADC1, ADC_Channel_1, 2, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_2, 3, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_3, 4, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_4, 5, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_5, 6, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_6, 7, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_7, 8, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_8, 9, ADC_SampleTime_239Cycles5 );
	ADC_RegularChannelConfig(ADC1, ADC_Channel_9, 10, ADC_SampleTime_239Cycles5 );
	
	
	ADC_DMACmd(ADC1, ENABLE);  //ADCDMA֧
	
  ADC_Cmd(ADC1, ENABLE);	//ʹָADC1
	
	
	ADC_ResetCalibration(ADC1);	//ʹܸλУ׼  
	 
	while(ADC_GetResetCalibrationStatus(ADC1));	//ȴλУ׼
	
	ADC_StartCalibration(ADC1);	 //ADУ׼
 
	while(ADC_GetCalibrationStatus(ADC1)); //ȴУ׼
 
  ADC_SoftwareStartConvCmd(ADC1, ENABLE);		//ʹָADC1ת

}		





u16 ReadADCAverageValue(u8 Channel)            //ÿͨȡ10Σƽֵ
{ 
    u8 i;
	  u32 sum=0;
    for(i=0; i<Sample_Num; i++)
    { 
     sum+=ADC_ConvertedValue[i][Channel]; 
    } 
    return (sum/Sample_Num); 
}



























